% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program PhaseScrambledImage.m
[M, map] = imread('Church.jpg',  'jpeg');    
M1 = rgb2gray(M);
fM = fftshift(fft2(M1 - mean2(M1))); %Fourier transformation
Sz = size(M1);
m_fM = abs(fM);     % extract the magnitudes spectrum
R = 2*rand(Sz)-0.5; % generate a random image of the same size
fR = fftshift(fft2(R - mean2(R))); 
        % perform Fourier transformation on the random image
p_fR = angle(fR);   % extract the phase spectrum of 
                    % the random image
fM2 = complex(m_fM.*cos(p_fR),  m_fM.*sin(p_fR)); 
        % combine the original magnitude spectrum with the 
        % random phase spectrum  
M2 = real(ifft2(fftshift(fM2))) + mean2(M1);
showImage(M2,   'grayscale');

